#version 330
#extension GL_EXT_gpu_shader4 : enable
//MandleBulbMod01.fsh by  UberAtlas
//https://www.shadertoy.com/view/fdjSWD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


//////////////////////
// Raymarch Config
//////////////////////
const int MAX_STEPS = 100;
const float MINIMUM_HIT_DISTANCE = 0.001;
const float MAXIMUM_TRACE_DISTANCE = 500.0;
const float DARKNESS = 35.0;

//////////////////////
// MandleBulb Config
//////////////////////
const int ITERATIONS = 15;
const float BULB_SCALE = 0.5;

// Adapted from: http://blog.hvidtfeldts.net/index.php/2011/09/distance-estimated-3d-fractals-v-the-mandelbulb-different-de-approximations/
float mandleBulbDistance(vec3 pos) {
	vec3 z = pos;
	float dr = 1.;
	float r = 0.0;
    float power = 1. + iTime / 15.;

	for (int i = 0; i < ITERATIONS ; i++) {
		r = length(z);
		if (r > 2.) break;

		// convert to polar coordinates
        float theta = asin( z.z/r );
        float phi = atan( z.y,z.x );
		dr =  pow(r, power - 1.0) * power * dr + 1.0;

		// scale and rotate the point
		float zr = pow(r, power);
		theta = theta * power;
		phi = phi * power;

		// convert back to cartesian coordinates
		z = zr * vec3(cos(theta) * cos(phi), cos(theta) * sin(phi), sin(theta));
		z += pos;
	}

	return BULB_SCALE * log(r) * r / dr;
}

float world(in vec3 pos) {
    return mandleBulbDistance(pos);
}

vec3 normalOfPos(in vec3 pos) {
    const vec3 step = vec3(0.001, 0.0, 0.0);

    float gradX = world(pos + step.xyy) - world(pos - step.xyy);
    float gradY = world(pos + step.yxy) - world(pos - step.yxy);
    float gradZ = world(pos + step.yyx) - world(pos - step.yyx);

    vec3 normal = vec3(gradX, gradY, gradZ);

    return normalize(normal);
}

// Adapted from https://michaelwalczyk.com/blog-ray-marching.html
vec3 rayMarch(in vec3 ro, in vec3 rd, in vec2 uv) {
    float totalDistanceTraveled = 0.0;
    
    vec3 color = mix(sin(iTime / 7. + vec3(1.4,0.7,10.1)), vec3(uv.x), vec3(uv.y)) * 0.3;
    
    int steps = 0;
    while (steps < MAX_STEPS) {
        // Calculate our current position along the ray
        vec3 curPos = ro + totalDistanceTraveled * rd;

        float distToClosest = mandleBulbDistance(curPos);
        
        // Hit
        if (distToClosest < MINIMUM_HIT_DISTANCE) {
            vec3 normal = normalOfPos(curPos);
            vec3 lightPos = vec3(1., 2., 3.);
            vec3 lightDir = normalize(curPos - lightPos);
            float diffuseIntensity = max(0.0, dot(normal, lightDir));
            color = sin(iTime / 7. + curPos.zyx + vec3(1.4,0.7,10.1)) * diffuseIntensity;
            break;
        }
        
        // Miss
        if (totalDistanceTraveled > MAXIMUM_TRACE_DISTANCE) break;

        // accumulate the distance traveled thus far
        totalDistanceTraveled += distToClosest;
        
        steps += 1;
    }

    // Inspired by https://github.com/SebLague/Ray-Marching/blob/f7e44c15a212dec53b244b1f53cdaf318f6ec700/Assets/Scripts/Fractal/Fractal.compute
    float rim = float(steps) / DARKNESS;
    return color * rim;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy / iResolution.xy;

    vec3 cameraPos = vec3(-.7, -.5, -2.);
    vec3 ro = cameraPos;
    vec3 rd = vec3(uv, 0.75);

    // Time varying pixel color
    vec3 col = rayMarch(ro, rd, uv);

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}